  group cd_toolbar {
    lock top, left, height;
    bordertype none;
    geometry 0, 0, 1500, 40;

    line vl1 {
      geometry 182, 0, 1, 37;
      lock top, left, width, height;
      layout vertical;
    }

    line vl2 {
      geometry 441, 0, 1, 37;
      lock top, left, width, height;
      layout vertical;
    }

    line vl3 {
      geometry 604, 0, 1, 37;
      lock top, left, width, height;
      layout vertical;
    }

    line lhbottom {
      geometry 0, 39, 1500, 1;
      lock left, right, top, bottom;
      layout horizontal;
    }

    group groupZoom {
      geometry 0, 0, 180, 38;
      lock top, left, width, height;
      bordertype none;
      group_toolbar;

      label laZoom {
        geometry 0, 0, 179, 13;
        lock top, left, height;
        title above center "Zoom";
      }

      button buttonZoomout {
        geometry 0, 13, 25, 25;
        lock top, left, width;
        icon "zoomoutlabel.icon";
        enableautorepeat;
        info "Decrement Zoom";

        on mousedown
        {
          ZoomLevel(0.9);
        }
      }

      thumbwheel twZoom
      {
        noborder;
        geometry 25, 19, 105, 12;
        lock left, height, width;

        info "Zoom thumbwheel";
        min -1000000;
        max 1000000;
        value 512;
        delta 1;
        layout horizontal;

        on mousedown
        {    
          set cumlzoomvalue = 1.0;
          set prevzoomvalue = $twZoom;
        }

        on valuechanged
        {
          if ($prevzoomvalue < $twZoom) 
          {
            set cumlzoomvalue = $cumlzoomvalue + 0.02;
            ZoomLevel(1.05);
          }

          if ($prevzoomvalue > $twZoom) 
          {
            set cumlzoomvalue = $cumlzoomvalue - 0.02;
            ZoomLevel(0.95);
          }

          set prevzoomvalue = $twZoom;
        }

        on mouseup
        {
          /*zoomimage (1, $cumlzoomvalue);*/
        }
      }

      button buttonZoomin {
        geometry 130, 13, 25, 25;
        lock left, height, width;
        icon "zoominlabel.icon";
        enableautorepeat;
        info "Increment Zoom";

        on mousedown
        {
          zoomlevel(1.1);
        }
      }

      button buttonDefaultzoom{
        geometry 152, 13, 25, 25;
        lock left, height, width;
        icon "reset.ico";
        info "Reset Zoom";
        on mousedown
        {
           set rotangle = edis_ResetScale();
           DefaultZoom();
           set rotangle = 0;
        }
      } 
    }

    group groupGeneral
    {
      bordertype none;
      geometry 185, 0, 254, 38;
      lock top, left, width, height;

      label laGeneral {
        geometry 0, 0, 260, 12;
        lock top, left, width, height;
        title above center "General Controls";
      }

      group_toolbar;

      button leftswipe
      {
        title "Swipe";
        geometry 0,13,28,25;
        lock top, left, width, height;
        icon "dqswipe.ico";
        info "Perform layer swipe in the left-hand view";
        on mousedown
        {
          if($leftflicker == 1)
          {
            LeftFlicker();
            set leftflicker = 0;
          }
          LeftSwipe();
        }
      }

      button leftflicker
      {
        title "Flicker";
        geometry 29,12,28,25;
        lock top, left, width, height;
        value 0;
        icon "dqflicker.ico";
        info "Perform layer flicker in the left-hand view";
        on mousedown
        {
          LeftFlicker();
        }
      }

      button leftmeasuretool {
        geometry 58,13,28,25;
        lock top, left, width, height;
        icon "ruler.icon";
        info "Measure Points, Lines and Areas in both views";
        on mousedown {
          LeftMeasure();
          RightMeasure();
        }
      }

      button cbNortharrow{
        geometry 87,13,28,25;
        lock top, left, width, height;
        value 0;
        info "Interactive North Arrow on/off in both views";
        icon "northarrow.ico";
        on mousedown
        { 
            if($NortharrowInUse == 1)
           {
               set NortharrowInUse = 0;
           }
           else
           {
               set NortharrowInUse = 1;
           }
           ViewNorth($NortharrowInUse);
        }
      }

      button cbScalebar{
        geometry 116,13,28,25;
        lock top, left, width, height;
        value 0;
        info "Interactive Scale Bar on/off in both views";
        icon "scalebar.ico";
        on mousedown
        { 
           if($ScalebarInUse == 1)
           {
              set ScalebarInUse = 0;
           }
           else
           {
              set ScalebarInUse = 1;
           }
           ViewScale($ScalebarInUse);
        }
      }

      button cbInviewMag{
        geometry 145,13,28,25;
        lock top, left, width, height;
        info "Open/Close the Change Magnifier in both views";
        icon "magnifier.ico";
        on mousedown
        {
          if($MagInUse == 1)
          {
             set MagInUse = 0;
          }
          else
          {
             set MagInUse = 1;
          }
          ChooseToolSetItem("cursorbutton");
          ViewMagnifier($MagInUse);
        }
      } 

      button MagCenter{
        geometry 168, 13, 28, 25;
        lock top, left, width, height;
        info "Select magnification center in both views.";
        icon "magnifiercentercursor.ico";
        on mousedown
        {
           set segmentoff = 0;
           set segmenton = 0;

           SelectTool("select"); 
           ChooseToolSetItem("cursorbutton");
           CenterMagnifier();
        }
      }

      button InviewMagProperties{
        geometry 197,13,28,25;
        lock top, left, width, height;
        info "Open the Change Magnifier Properties for both views";
        icon "magnifierproperties.ico";
        on mousedown 
        {
          display frame_changemag;
        }
      }

      button rightflicker
      {
        geometry 226,12,28,25;
        lock top, left, width, height;
        value 0;
        icon "dqblack.ico";
        info "Toggle the visiblity of the background layer on the right-hand view";
        on mousedown
        {
          RightFlicker();
        }
      } 
    }

    group groupBeforeAfter {
      geometry 445, 0, 157, 38;
      lock top, left, width, height;
      bordertype none;

      radiobutton lutstate {
         geometry 0,0,70,40;
         titlelist {
            "Before",
            "After",
            "Transition"
         };
         info "Select Before, After or Transition classes in the right-hand view";
         options { "before","after","transition" };
         on valuechanged {
            if ($lutstate == "before") {
               BeforeState();
            }
            if ($lutstate == "after") {
               AfterState();
            }
            if ($lutstate == "transition") {
               TransitionState();
            }
         }
      }

      checkbox segmentoff
      {
        geometry 75,0,20,20;
        lock top, left, width, height;
        value 0;
        icon "dqsubtract.ico";
        info "Turn segment selection off";
        on mousedown
        {
          OffSegment(1);
        }
      }

      checkbox segmenton
      {
        geometry 75,20,20,20;
        lock top, left, width, height;
        value 0;
        icon "dqadd.ico";
        info "Turn segment selection on";
        on mousedown
        {
          OnSegment(1);
        }
      }

      button segmentapply
      {
        geometry 105,0,55,20;
        title "Apply";
        info "Apply segmentation selections";
        on mousedown
        {
          ApplySegment();
        }
      }  
      button segmentreset
      {
        geometry 105,20,55,20;
        title "Reset";
        info "Reset segmentation selections";
        on mousedown
        {
          ResetSegment();
        }
      }  
    }

    group groupSpectral {
      geometry 607, 0, 200, 38;
      lock top, left, width, height;
      bordertype none;

      popuplist plRed;
      popuplist plGreen;
      popuplist plBlue;

      label laSpectral {
        geometry 2, 0, 200, 12;
        lock top, left, width, height;
        title above center "Spectral";
      }

      popuplist plRed {
        titlegap 0.4;
        editable;
        geometry 2, 13, 60, 20;
        title left center "R";
        info "Band Combination Selector for both views";
        on input {
          LeftBands ($plRed, $plGreen, $plBlue);
          RightBands($plRed, $plGreen, $plBlue);
        }
      }

      popuplist plGreen {
        titlegap 0.4;
        editable;
        geometry 62, 13, 60, 20;
        lock top, left, width, height;
        title left center "G";
        info "Band Combination Selector for both views";
        on input {
          LeftBands ($plRed, $plGreen, $plBlue);
          RightBands($plRed, $plGreen, $plBlue);
        }
      }

      popuplist plBlue {
        titlegap 0.4;
        editable;
        geometry 122, 13, 60, 20;
        lock top, left, width, height;
        title left center "B";
        info "Band Combination Selector for both views";
        on input {
          LeftBands ($plRed, $plGreen, $plBlue);
          RightBands($plRed, $plGreen, $plBlue);
        }
      }
    }
  }
